/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package finalproject;

/**
 *
 * @author Roy
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JOptionPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class GUI extends javax.swing.JFrame {

    public static final int minPassLen = 6;
    public static final int maxPassLen = 32;
    public static final String fileName = "data000.enc";
    public static final int tableSize = 95;
    public static final short[] HeaderStart = new short[] { 
        0xfa, 0xd6, 0xd8, 0xce,
        0xda, 0xe4, 0xf8, 0xca,
        0xfd, 0xf1, 0xc3, 0xe6,
        0xc4, 0xfa, 0xd1, 0xe8,
        0xe2, 0xd5, 0xfa, 0xe2,
        0xfa, 0xe9, 0xfa, 0xf5,
        0xe7, 0xf9, 0xd2, 0xc4,
        0xce, 0xe8, 0xff, 0xf9
    };
    public static final short[] HeaderEnd = new short[] { 
        0xaa, 0x95, 0x68, 0xf5,
        0x41, 0xc4, 0xb3, 0xb4,
        0xe1, 0x42, 0xe4, 0x65,
        0x62, 0xc4, 0xf0, 0xf3,
        0x3e, 0x88, 0xa4, 0xb2,
        0xcf, 0xec, 0xfe, 0xf6
    };
    
    public static final char breakerData = (char) 0x7f;
    
    boolean overWriteData = false;
    int [][] M;
    
    long unixTime = 0;
    
    boolean isFExist = false;
    String tempPassword = "";
    String ePass = "";
    
    List<String> data = new ArrayList<>();
    
    Timer timer = new Timer();
    
    /**
     * Creates new form GUI
     */
    public GUI() {
        initComponents();
        createTable();
    }
    
    public void createTable()
    {
        M = new int [tableSize][tableSize];
        
        int k = 1;
        
        for (int i = 0; i < tableSize; i++)
            for (int j = 0; j < tableSize; j++)
                M[i][j] = k++;
    }
    
    /**
     * Get the encrypted number of two chars.
     * 
     * @param t1 The first char.
     * @param t2 The second char.
     * @return The encrypted number of the two chars.
     */
    public int getNum(char t1, char t2){
        int r = t1 - 32;
        int c = t2 - 32;
        
        return M[r][c];
    }
    
    /**
     * Get two decrypted chars from an encrypted number.
     * 
     * @param x The encrypted number.
     * @return The two decrypted chars from an encrypted number.
     */
    public char[] getChar(int x) {
        char [] c = new char [2];
        
        for (int i = 0; i < tableSize; i++)
        {
            for (int j = 0; j < tableSize; j++)
            {
                if (M[i][j] == x)
                {
                    c[0] = (char) (i + ' ');
                    c[1] = (char) (j + ' ');
                    
                    break;
                }
             }
        }
        
        return c;
    }
    
    /**
     * Encrypts the message
     * 
     * @param msg The message
     * @return The encrypted message
     */
    public String EncryptMessage(String msg)
    {
        if (msg.equals(""))
            return msg;
        
        String eMsg = "";
            
        if (msg.length() % 2 == 1)
            msg+= ' ';
            
        for (int i = 0; i < msg.length(); i+=2)
            eMsg += getNum(msg.charAt(i),msg.charAt(i+1)) + "•";
        
        return eMsg;
    }
    
    /**
     * Decrypts the message
     * 
     * @param msg The encrypted message
     * @exception java.lang.NumberFormatException if something went wrong
     * @return The decrypted message
     */
    public String DecryptMessage(String msg) throws java.lang.NumberFormatException
    {
        String dMsg = "";
            
        String[] splitMsg = msg.split("•");
        int theNum;
        char [] tC = new char [2];
            
        try
        {
            for (int i = 0; i < splitMsg.length; i++)
            {
                theNum = Integer.parseInt(splitMsg[i]);
                tC = getChar(theNum);

                dMsg += tC[0] + "" + tC[1];
            }
        }
            
        finally
        {
            return dMsg;
        }      
    }
    
    /**
     * Check if file exists.
     * 
     * @param filename The file path (include name).
     * @return True if exist, false if not
     */
    public boolean isFileExist(String filename)
    {
        File file = new File(filename);
        
        return (file.exists() && file.isFile());
    }
    
    /**
     * Reads data from file.
     * 
     * @param filename The file path (include name).
     * @param data The array where the data is saved (ArrayList String).
     * @exception IOException if something went wrong
     * @return True if no data had been found.
     */
    public boolean ReadFromFile(String filename, List<String> data) throws IOException
    {
        data.clear();
        
        try
        {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            
            String hStart = "";
            String hEnd = "";
            
            for (int i = 0; i < HeaderStart.length; i++)
                hStart+=Character.toString((char)HeaderStart[i]);
        
            for (int i = 0; i < HeaderEnd.length; i++)
                hEnd+=Character.toString((char)HeaderEnd[i]);

            if (br.ready())
            {
                String tmp = br.readLine();
                String [] tmp2 = tmp.split(Character.toString(breakerData));
                
                if (tmp2[0].equals(hStart) && tmp2[3].equals(hEnd))
                {
                    data.add(tmp);
                    
                    ePass = StrongDecryptPassword(tmp2[1]);
                    unixTime = Long.parseLong(tmp2[2]);
                    
                    while (br.ready())
                        data.add(br.readLine());                
                }

                else
                {
                    JOptionPane.showMessageDialog(this, "Unknown format: File is corrupted", "Error", JOptionPane.ERROR_MESSAGE);
                    System.err.println("Error: File \"" + filename + "\" is corrupted");
                    System.exit(1);
                }
            }
            
            br.close();
        } 
        
        finally
        {
            return data.isEmpty();
        }
    }
    
    /**
     * Writes data to file.
     * 
     * @param filename The file path (include name).
     * @param data The data to write (ArrayList String).
     * @exception IOException if something went wrong
     */
    public void WriteToFile(String filename, List<String> data) throws IOException
    {        
        try
        {
            boolean tmp = isFExist && overWriteData;
            
            FileWriter fw = new FileWriter(filename,(!tmp));
            BufferedWriter bw = new BufferedWriter(fw);
            
            if (tmp || !isFExist)
            {
                for (int i = 0; i < data.size(); i++)
                {
                    bw.write(data.get(i));
                    bw.newLine();
                }
            }
            
            else
            {
                for (int i = 1; i < data.size(); i++)
                {
                    bw.write(data.get(i));
                    bw.newLine();
                }
            }
            
            bw.close();
        } 
            
        finally
        {
            
        }
    }
    
    /**
     * Encrypt a string 
     * 
     * @param password The pass we want to encrypt.
     * @return The encrypted password.
     */
    public String EncryptPassword(String password)
    {
        try
        {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(password.getBytes());

            byte byteData[] = md.digest();

            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < byteData.length; i++)
                sb.append(Integer.toString((byteData[i] & 0xff) + 0x100, 16).substring(1));

            return sb.toString();
        }
        
        catch(NoSuchAlgorithmException ex)
        {
            System.out.println("Great! You broke it!\nErr: " + ex);
            System.exit(2);
            return "";
        }
    }
    
    public String StrongEncryptPassword(String password)
    {
        String ePass = "";
        char d;
        
        for (int i = 0; i < password.length(); i++)
        {
            d = (char) (password.charAt(i) + ((char) 100));
            ePass+=d;
        }
        
        return ePass;
    }
    
    public String StrongDecryptPassword(String ePass)
    {
        String dPass = "";
        char d;
        
        for (int i = 0; i < ePass.length(); i++)
        {
            d = (char) (ePass.charAt(i) - ((char) 100));
            dPass+=d;
        }
        
        return dPass;
    }
    
    /**
     * Gets the date && time.
     * 
     * @return The current date && time
     */
    public Date getDate()
    {
        return new Date();
    }
    
    public String getDate(Date date)
    {
        DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        return dateFormat.format(date);
    }
    
    /**
     * Gets unix time format
     * 
     * @return The current unix time
     */ 
    public long getUnixTime()
    {
        return (System.currentTimeMillis()/1000L);
    }
    
    /**
     * Converts date to unix format
     * 
     * @param theDate The date.
     * @return The unix format
     */
    public long DateToUnix(Date theDate)
    {
        return (theDate.getTime() / 1000L);
    }
    
    /**
     * Converts unix format to date
     * 
     * @param unixt Unix time
     * @return The date
     */
    public Date UnixToDate(long unixt)
    {
        Date date = new Date((unixt*1000L));
        
        return date;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jDialog1 = new javax.swing.JDialog();
        jPanel2 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jPasswordField = new javax.swing.JPasswordField();
        jButtonCheckPassword = new javax.swing.JButton();
        jDialog2 = new javax.swing.JDialog();
        jPanel3 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jButtonClose = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane = new javax.swing.JScrollPane();
        jTextArea = new javax.swing.JTextArea();
        jButtonSaveData = new javax.swing.JButton();
        jButtonLoadData = new javax.swing.JButton();
        jButtonAbout = new javax.swing.JButton();
        jCheckBoxOverWriteData = new javax.swing.JCheckBox();
        jLabelCurrentTime = new javax.swing.JLabel();
        jLabelLastEdit = new javax.swing.JLabel();

        jDialog1.setTitle("Final Project - Encrypted Diary");
        jDialog1.setResizable(false);
        jDialog1.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                jDialog1WindowClosed(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                jDialog1WindowClosing(evt);
            }
        });

        jPanel2.setBackground(new java.awt.Color(0, 204, 0));
        jPanel2.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(51, 255, 255), 4, true));

        jLabel2.setFont(new java.awt.Font("Arial", 1, 24)); // NOI18N
        jLabel2.setText("Enter Password:");

        jLabel3.setFont(new java.awt.Font("Arial", 1, 48)); // NOI18N
        jLabel3.setText("Encrypted Diary");

        jPasswordField.setFont(new java.awt.Font("Arial", 0, 14)); // NOI18N
        jPasswordField.setHorizontalAlignment(javax.swing.JTextField.CENTER);

        jButtonCheckPassword.setFont(new java.awt.Font("Arial", 1, 24)); // NOI18N
        jButtonCheckPassword.setText("Enter Diary");
        jButtonCheckPassword.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCheckPasswordActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(86, 86, 86)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPasswordField, javax.swing.GroupLayout.PREFERRED_SIZE, 369, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel3)))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(180, 180, 180)
                        .addComponent(jLabel2))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(137, 137, 137)
                        .addComponent(jButtonCheckPassword, javax.swing.GroupLayout.PREFERRED_SIZE, 268, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(128, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel3)
                .addGap(18, 18, 18)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPasswordField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE)
                .addComponent(jButtonCheckPassword)
                .addGap(20, 20, 20))
        );

        javax.swing.GroupLayout jDialog1Layout = new javax.swing.GroupLayout(jDialog1.getContentPane());
        jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        jDialog1Layout.setVerticalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        jDialog2.setTitle("Final Project - Encrypted Diary");
        jDialog2.setResizable(false);
        jDialog2.addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                jDialog2WindowClosing(evt);
            }
        });

        jPanel3.setBackground(new java.awt.Color(0, 204, 0));
        jPanel3.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(51, 255, 255), 4, true));

        jLabel4.setFont(new java.awt.Font("Arial", 1, 24)); // NOI18N
        jLabel4.setText("This is a simple Encrypted Diary to store things secretly.");

        jLabel5.setFont(new java.awt.Font("Arial", 1, 48)); // NOI18N
        jLabel5.setText("About");

        jButtonClose.setFont(new java.awt.Font("Arial", 1, 24)); // NOI18N
        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jLabel6.setFont(new java.awt.Font("Arial", 1, 24)); // NOI18N
        jLabel6.setText("The program is desinged to read a specific file.");

        jLabel7.setFont(new java.awt.Font("Arial", 1, 24)); // NOI18N
        jLabel7.setText("Any attemps to edit this file will corrupt the file.");

        jLabel9.setFont(new java.awt.Font("Arial", 1, 24)); // NOI18N
        jLabel9.setText("Author of the project: Roy");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel4))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(243, 243, 243)
                        .addComponent(jLabel5))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel6))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel7))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel9))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(256, 256, 256)
                        .addComponent(jButtonClose)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGap(5, 5, 5)
                .addComponent(jLabel5)
                .addGap(18, 18, 18)
                .addComponent(jLabel4)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel7)
                .addGap(18, 18, 18)
                .addComponent(jLabel9)
                .addGap(18, 18, 18)
                .addComponent(jButtonClose)
                .addContainerGap(47, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jDialog2Layout = new javax.swing.GroupLayout(jDialog2.getContentPane());
        jDialog2.getContentPane().setLayout(jDialog2Layout);
        jDialog2Layout.setHorizontalGroup(
            jDialog2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        jDialog2Layout.setVerticalGroup(
            jDialog2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Final Project - Encrypted Diary");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setBackground(new java.awt.Color(0, 204, 0));
        jPanel1.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(51, 255, 255), 4, true));

        jLabel1.setFont(new java.awt.Font("Arial", 1, 48)); // NOI18N
        jLabel1.setText("Encrypted Diary");

        jTextArea.setColumns(20);
        jTextArea.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
        jTextArea.setRows(5);
        jScrollPane.setViewportView(jTextArea);

        jButtonSaveData.setFont(new java.awt.Font("Arial", 1, 18)); // NOI18N
        jButtonSaveData.setText("Save");
        jButtonSaveData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveDataActionPerformed(evt);
            }
        });

        jButtonLoadData.setFont(new java.awt.Font("Arial", 1, 18)); // NOI18N
        jButtonLoadData.setText("Load");
        jButtonLoadData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonLoadDataActionPerformed(evt);
            }
        });

        jButtonAbout.setFont(new java.awt.Font("Arial", 1, 18)); // NOI18N
        jButtonAbout.setText("About");
        jButtonAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAboutActionPerformed(evt);
            }
        });

        jCheckBoxOverWriteData.setBackground(new java.awt.Color(0, 204, 0));
        jCheckBoxOverWriteData.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
        jCheckBoxOverWriteData.setText("Overwrite data");
        jCheckBoxOverWriteData.setEnabled(false);

        jLabelCurrentTime.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
        jLabelCurrentTime.setText("Current Time: 01/01/1970 00:00:00");

        jLabelLastEdit.setFont(new java.awt.Font("Arial", 1, 14)); // NOI18N
        jLabelLastEdit.setText("Last Diary Edit: 01/01/1970 00:00:00");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap(53, Short.MAX_VALUE)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGap(10, 10, 10)
                                .addComponent(jButtonLoadData)
                                .addGap(349, 349, 349)
                                .addComponent(jButtonAbout)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jCheckBoxOverWriteData)
                                .addGap(18, 18, 18)
                                .addComponent(jButtonSaveData))
                            .addComponent(jScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 1041, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(42, 42, 42))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabelCurrentTime)
                            .addComponent(jLabelLastEdit))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLabel1)
                        .addGap(376, 376, 376))))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel1)
                            .addComponent(jLabelLastEdit)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(jLabelCurrentTime)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane, javax.swing.GroupLayout.PREFERRED_SIZE, 377, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jButtonSaveData)
                        .addComponent(jButtonLoadData)
                        .addComponent(jCheckBoxOverWriteData))
                    .addComponent(jButtonAbout))
                .addContainerGap(22, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        TimerTask tTask = new TimerTask() {

            @Override
            public void run() {
                jLabelCurrentTime.setText("Current Time: " + getDate(getDate()));
            }
        };
        
        timer.scheduleAtFixedRate(tTask, 1000, 1000);
            
        
        this.setVisible(false);
        
        if (isFileExist(fileName))
        {
            isFExist = true;
            try
            {
                ReadFromFile(fileName, data);
                jCheckBoxOverWriteData.setEnabled(true);
            }
            
            catch (IOException ex)
            {
                JOptionPane.showMessageDialog(this, "Failed to open file\n" + ex, "Error", JOptionPane.ERROR_MESSAGE);
            }
        }
        
        else
        {
            jButtonCheckPassword.setText("Set Password");
        }
        
        jDialog1.setVisible(true);
        jDialog1.setSize(591, 240);
    }//GEN-LAST:event_formWindowOpened

    private void jDialog1WindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_jDialog1WindowClosed
        // USELESS
        // HOW TO REMOVE THIS?!!?!
    }//GEN-LAST:event_jDialog1WindowClosed

    private void jDialog1WindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_jDialog1WindowClosing
        System.exit(0);
    }//GEN-LAST:event_jDialog1WindowClosing

    private void jButtonCheckPasswordActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCheckPasswordActionPerformed
        if (isFExist)
        {
            char [] pass = jPasswordField.getPassword();
            for (int i = 0; i < pass.length; i++)
                tempPassword += pass[i];
                
            if (EncryptPassword(tempPassword).equals(ePass))
            {
                jDialog1.setVisible(false);
                this.setVisible(true);
            }
                
            else
                JOptionPane.showMessageDialog(this, "Wrong Password!", "Error", JOptionPane.ERROR_MESSAGE);
            
            jLabelLastEdit.setText("Last Diary Edit: " + getDate(UnixToDate(unixTime)));
        }
        
        else
        {
            char [] pass = jPasswordField.getPassword();
            
            if (pass.length < minPassLen || pass.length > maxPassLen)
                JOptionPane.showMessageDialog(this, "Password is too short/too long.\nMin. password length: " + minPassLen + "\nMax. password length: " + maxPassLen, "Warning", JOptionPane.WARNING_MESSAGE);
            
            else
            {
                for (int i = 0; i < pass.length; i++)
                    tempPassword += pass[i];

                try
                {
                    ePass = EncryptPassword(tempPassword);
                }
                
                catch (Exception ex)
                {
                    JOptionPane.showMessageDialog(this, "Something went wrong :-(\n" + ex, "Error", JOptionPane.ERROR_MESSAGE);
                }
                
                jDialog1.setVisible(false);
                this.setVisible(true);
            }
        }
    }//GEN-LAST:event_jButtonCheckPasswordActionPerformed

    private void jButtonSaveDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveDataActionPerformed
        data.clear();
        
        unixTime = getUnixTime();
        
        String hStart = "";
        String hEnd = "";
            
        for (int i = 0; i < HeaderStart.length; i++)
            hStart+=Character.toString((char)HeaderStart[i]);
        
        for (int i = 0; i < HeaderEnd.length; i++)
            hEnd+=Character.toString((char)HeaderEnd[i]);
        
        String theData[] = new String[] { hStart,
            Character.toString(breakerData),
            StrongEncryptPassword(ePass),
            Character.toString(breakerData),
            Long.toString(unixTime),
            Character.toString(breakerData),
            hEnd 
        };
        String tmp = "";
                    
        for (int i = 0; i < theData.length; i++)
            tmp+=theData[i];
        
        data.add(tmp);
            
        try
        {        
            if (!isFExist)
                jCheckBoxOverWriteData.setEnabled(false);
            
            if (jCheckBoxOverWriteData.isSelected())
                overWriteData = true;
            
            else
                overWriteData = false;
            
            data.addAll(Arrays.asList(jTextArea.getText().split("\\n")));
            
            for (int i = 1; i < data.size(); i++)
                data.set(i, EncryptMessage(data.get(i)));
            
            WriteToFile(fileName, data);
            JOptionPane.showMessageDialog(this, "Data saved to file \"" + fileName + "\"", "Info", JOptionPane.INFORMATION_MESSAGE);
            
            jLabelLastEdit.setText("Last Diary Edit: " + getDate(getDate()));
            jCheckBoxOverWriteData.setEnabled(true);
            
            isFExist = true;
        }
        
        catch (Exception ex)
        {
            JOptionPane.showMessageDialog(this, "Something went wrong :-(\n" + ex, "Error", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_jButtonSaveDataActionPerformed

    private void jButtonLoadDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonLoadDataActionPerformed
        try
        {
            
            ReadFromFile(fileName, data);
            jLabelLastEdit.setText("Last Diary Edit: " + getDate(UnixToDate(unixTime)));
            
            if (!jTextArea.getText().isEmpty())
            {
                int rep = JOptionPane.showConfirmDialog(this, "Are you sure you want to load the data?\nAny changes will be discared", "Info", JOptionPane.OK_CANCEL_OPTION);
                
                if (rep == JOptionPane.OK_OPTION)
                {
                    jTextArea.setText("");
            
                    for (int i = 1; i < data.size(); i++)
                    {
                        data.set(i, DecryptMessage(data.get(i)));
                        jTextArea.setText(jTextArea.getText() + data.get(i) + "\n");
                    }

                    JOptionPane.showMessageDialog(this, "Data loaded from file \"" + fileName + "\"", "Info", JOptionPane.INFORMATION_MESSAGE);
                }
            }
            
            else
            {
                jTextArea.setText("");
                String temp = "";
            
                for (int i = 1; i < data.size(); i++)
                {
                    data.set(i, DecryptMessage(data.get(i)));
                    jTextArea.setText(jTextArea.getText() + data.get(i) + "\n");
                }

                JOptionPane.showMessageDialog(this, "Data loaded from file \"" + fileName + "\"", "Info", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        
        catch(IOException ex)
        {
            JOptionPane.showMessageDialog(this, "Something went wrong :-(\n" + ex, "Error", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_jButtonLoadDataActionPerformed

    private void jButtonAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAboutActionPerformed
        this.setVisible(false);
        jDialog2.setVisible(true);
        jDialog2.setSize(690,320);
    }//GEN-LAST:event_jButtonAboutActionPerformed

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        jDialog2.setVisible(false);
        this.setVisible(true);
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jDialog2WindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_jDialog2WindowClosing
        jDialog2.setVisible(false);
        this.setVisible(true);
    }//GEN-LAST:event_jDialog2WindowClosing

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(GUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(GUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(GUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(GUI.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new GUI().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAbout;
    private javax.swing.JButton jButtonCheckPassword;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonLoadData;
    private javax.swing.JButton jButtonSaveData;
    private javax.swing.JCheckBox jCheckBoxOverWriteData;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JDialog jDialog2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabelCurrentTime;
    private javax.swing.JLabel jLabelLastEdit;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPasswordField jPasswordField;
    private javax.swing.JScrollPane jScrollPane;
    private javax.swing.JTextArea jTextArea;
    // End of variables declaration//GEN-END:variables
}
